IF OBJECT_ID('P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV') IS NOT NULL
    BEGIN
        DROP PROCEDURE P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV;
    END;
GO

CREATE PROCEDURE P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV(@FLAG_LIMPAR INT = 0)
WITH ENCRYPTION
AS
    BEGIN TRY
        BEGIN
            IF OBJECT_ID('Tempdb.dbo.##CTB_EXP_MOV') IS NOT NULL
                BEGIN
                    IF @FLAG_LIMPAR = 1
                        BEGIN
                            DROP TABLE ##CTB_EXP_MOV;
                        END;
                    ELSE
                        BEGIN
                            RETURN;
                        END;
                END;
            CREATE TABLE ##CTB_EXP_MOV
            (CD_LANC             INT IDENTITY(1, 1),
             CD_EMP              INT,
             CD_FILIAL_EXPORT    INT,
             CD_FILIAL           INT,
             CD_MOVIMENTO        INT,
             MOVIMENTO           VARCHAR(150),
             OPERACAO            VARCHAR(150),
             OPERACAO_DEBITO     VARCHAR(150),
             CD_CNT_RED_CREDITO  INT,
             CD_CNT_CREDITO      VARCHAR(20),
             CD_CNT_RED_DEBITO   INT,
             CD_CNT_DEBITO       VARCHAR(20),
             DT_MOV              DATETIME,
             HIST                VARCHAR(300),
             VLR_LANC            MONEY,
             TP_TRANSA           VARCHAR(3),
             RATEIO_CENTRO_CUSTO INT,
             DS_CENTRO_CUSTO     VARCHAR(150),
             CNT_CENTRO_CUSTO    VARCHAR(20),
             VLR_CENTRO_CUSTO    MONEY,
             ORIG_CONTA          VARCHAR(150),
             COD_CONTA           VARCHAR(150),
             NM_PROCEDURE        VARCHAR(150),
             TIPO_LANCTO         VARCHAR(1),
             CD_EVENTO           INT
            );
        END;
    END TRY
    BEGIN CATCH
        INSERT INTO ADM_ERRO
        (numero
       , severidade
       , estado
       , rotina
       , linha
       , mensagem
       , dtErro
        )
               SELECT ERROR_NUMBER() AS numero
                    , ERROR_SEVERITY() AS severidade
                    , ERROR_STATE() AS estado
                    , ERROR_PROCEDURE() AS rotina
                    , ERROR_LINE() AS linha
                    , ERROR_MESSAGE() AS mensagem
                    , GETDATE() AS dtErro;
    END CATCH;